import cv2
import numpy as np
from skimage import io
import os


path = r'C:\Users\Jakob\box.fu\Papers\Stripes\figure 1\simulation fences'
filename = 'stack_downsized'
full_filename = path + '/' + filename + '.tif'

img = io.imread(full_filename)
total_frames = img.shape[0]

noise_img = np.zeros((img.shape[1], img.shape[2]))
poisson_offset = 0
gauss_offset = 150
blur = 5

output_folder = filename + '_noisy' + '_poisson-offset_' + str(poisson_offset) + '_gauss-offset_' + str(gauss_offset) \
                + '_blur_' + str(blur)

if not os.path.isdir(path + '/' + output_folder ):
    os.mkdir(path + '/' + output_folder)

for frame in range(0, total_frames):

    #add blur by making mean of consecutive frames

    if frame >= blur:

        if not blur == 0:
            lower = frame - blur
            blurred = np.zeros((img.shape[1], img.shape[2]))
            for b in range(lower, frame):
                blurred += img[b]

            blurred = blurred / blur

        else:
            blurred = img[frame]

        #add gaussian noise (background)
        noisy_gauss = np.random.normal(noise_img + gauss_offset)

        #add poisson noise (camera noise)
        noisy_poisson = np.random.poisson(blurred + noisy_gauss + poisson_offset)

        final = noisy_poisson

        #for j in range(0, final.shape[1]):
            #for i in range(0, final.shape[0]):
            #if final[i, j] > 65535:
                    #final[i, j] = 65535


        final = np.array(final, dtype='uint16')

        cv2.imwrite(path + '/' + output_folder + '/' + filename + '_frame_' + str(frame) + '.tif', final)



